/*-----------------------------------------------------------------------

  * Structor Template v1.0 
  * Copyright 2021 The Structor Author (https://themeforest.net/user/gianfar)

  =======================================================================*/
"use strict";
$(document).ready(function() {

    // Preloader
    setTimeout(function() {
        $('body').addClass('loaded');
    }, 2000);
    /*add img in horizontal portfolio*/
    $('.htl-works-img').each(function(indx) {
        var dataBg = $(this).attr('data-htl-img');
        $(this).css('background', 'url(' + dataBg + ')');
    });
    /*add img in slider*/
    $('.img-slider').each(function(indx) {
        var dataBg = $(this).attr('data-img-slider');
        $(this).css('background', 'url(' + dataBg + ')');
    });
    /*add img in parallax-portfolio*/
    $('.p-works-item').each(function(indx) {
        var dataBg = $(this).attr('data-p-works-item');
        $(this).css('background', 'url(' + dataBg + ')');
    });
        /*add img in parallax-portfolio*/
    $('.anim-el-works').each(function(indx) {
        var dataBgWorks = $(this).attr('data-p-works-item');
        $(this).css('background', 'url(' + dataBgWorks + ')');
    });

    /*- NODE CURSOR -*/
    window.NodeCursor({
        cursor: true,
        node: true,
        cursor_velocity: 1,
        node_velocity: 0.1,
        element_to_hover: '.node-hover',
        element_to_hover_drag: '.drag',
        element_to_hover_zoom: '.zoom-el',
        element_to_hover_zoom_2: '.zoom-el-2',
        cursor_class_hover: 'disable',
        node_class_hover: 'expand',
        node_class_hover_drag: 'drag-cursor',
        node_class_hover_zoom: 'zoom-cursor',
        node_class_hover_zoom_2: 'zoom-cursor-2',
        hide_mode: false,
    });

    /*- INIT MASONRY GRID -*/
    /*2-columns*/
    var $masonryGrid_2 = $('#masonry-grid-2').masonry({
        itemSelector: '.masonry-item-2',
        percentPosition: true,
        columnWidth: '.masonry-grid-sizer-2',
        horizontalOrder: true,
    });
    /*3-columns*/
    var $masonryGrid_3 = $('#masonry-grid-3').masonry({
        itemSelector: '.masonry-item-3',
        percentPosition: true,
        columnWidth: '.masonry-grid-sizer-3',
        horizontalOrder: true,
    });


    // layout Masonry after each image loads:
    /*2-columns*/

    $masonryGrid_2.imagesLoaded({ background: true },function() {
        $masonryGrid_2.masonry();
    });
    $('.masonry-item-2:eq(1)').css("margin-top", "216px");

    /*3-columns*/
    $masonryGrid_3.imagesLoaded({ background: true },function() {
        $masonryGrid_3.masonry();
    });
    $('.masonry-item-3:eq(1)').css("margin-top", "216px");


    /*TAGLINE SECTION*/
    /*text speed */
    if (($(window).width()) < 768) {
        var speedText = 3000;
    } else {
        var speedText = 6000;
    }

    /*init text */
    $('.tagline-marquee').marquee({
        //speed in milliseconds of the marquee
        duration: speedText,
        //gap in pixels between the tickers
        gap: 10,
        //time in milliseconds before the marquee will start animating
        delayBeforeStart: 0,
        //'left' or 'right'
        direction: 'left',
        //true or false - should the marquee be duplicated to show an effect of continues flow
        duplicated: false,
        //pause the marquee on hover
        pauseOnHover: true,
    });

    function animatedText() {
        anime({
            targets: '.an-el-wrap .el-anime',
            translateY: [100, 0],
            opacity: [0, 1],
            duration: 900,
            delay: anime.stagger(100),
            easing: 'cubicBezier(0, 0.4, 0.5, 1.2)',
        });
    }

    function animatedMenuText() {
        if ($('.full-nav').hasClass('full-nav-on') === true) {
            anime({
                targets: '.full-nav-links .nav-img',
                translateY: [100, 0],
                opacity: [0, 1],
                duration: 900,
                delay: anime.stagger(100),
                easing: 'cubicBezier(0, 0.4, 0.5, 1.2)',
            });
        } else {
            return false;
        }
    }
    /*---- 1_NAVIGATION -----*/
    var $iconNav = $('.menu-icon'),
        $iconNav_1 = $('.icon-nav-1'),
        $iconNav_2 = $('.icon-nav-2'),
        $fullNav = $('.full-nav'),
        $topLayer = $('.top-layer'),
        $el = $('.el');


    /* 1.1_menu logo hover*/
    $iconNav.hover(
        function() {
            $iconNav_1.css("margin-top", "3px");
            $iconNav_2.css("margin-top", "0");

        },
        function() {
            $iconNav_1.css("margin-top", "0");
            $iconNav_2.css("margin-top", "6px");
        });

    /*sound on menu*/
    // function soundClick() {
    //     var audio = new Audio();
    //     audio.src = 'assets/media/button_click.mp3';
    //     audio.autoplay = true;
    // }
    /*1.2_Events Click*/
    function toogleEl() {
        $('body').toggleClass('scroll-hidden');
        $iconNav.toggleClass('icon-close');
        $iconNav_1.toggleClass('icon-nav-1-on');
        $iconNav_2.toggleClass('icon-nav-2-on');
        $fullNav.toggleClass('full-nav-on');
        $topLayer.toggleClass('active');
    }

    $('a').on('click', function(){
        // soundClick();
    });

    $iconNav.on('click', function() {
        // soundClick();
        if ($('.text-menu').html() === 'menu') {
            $('.text-menu').html('close');
        } else {
            $('.text-menu').html('menu');
        }

        $('.str-submenu').removeClass('show');
        toogleEl();
        animatedMenuText();
        anime({
            targets: '.menu-active-bg',
            translateY: [100, 0],
            scale: [1.2, 1],
            opacity: [0, 1],
            duration: 400,
            easing: 'easeInOutExpo',
        });
    });


    $('.icon-nav').on('click', function() {
        toogleEl();
    });

/*1.3 change background*/
var activeElMenu = $('.menu-active').parent().attr('data-menu-bg'); $('.' + activeElMenu).addClass('menu-active-bg');


var $menu_bg = $('.menu-bg'),
    $menu_active_bg = $('.menu-active-bg');

function activeBg() {
    $menu_active_bg.css({ 'opacity': '1', 'transition-duration': '.5s', 'z-index': '3', 'transform': 'scale(1)' });
}
activeBg();


$('.nav-img').hover(
    function() {
        $menu_active_bg.css({ 'opacity': '0', 'transition-duration': '.5s', 'z-index': '2'});
        var attrBg = $(this).attr('data-menu-bg');
        $('.' + attrBg).css({ 'z-index': '4', 'opacity': '1'});
    },
    function() {
        var attrBgOut = $(this).attr('data-menu-bg');
        $('.' + attrBgOut).css({ 'z-index': '2', 'opacity': '0', 'transition-duration': '.5s' });
        activeBg();
    });

// $('.nav-img').hover(
//     function() {
//         $menu_active_bg.css({ 'opacity': '0', 'transition-duration': '.5s', 'z-index': '2', 'transform': 'scale(1.2)' });
//         var attrBg = $(this).attr('data-menu-bg');
//         $('.' + attrBg).css({ 'z-index': '4', 'opacity': '1', 'transform': 'scale(1)' });
//     },
//     function() {
//         var attrBgOut = $(this).attr('data-menu-bg');
//         $('.' + attrBgOut).css({ 'z-index': '2', 'opacity': '0', 'transform': 'scale(1.2)', 'transition-duration': '.5s' });
//         activeBg();
//     });

//======= PARALLAX SLIDER ========
var parallaxSliderOptions = {
    speed: 1000,
    parallax: true,
    loop: true,
    centeredSlides: true,
    slidesPerView: 1,
    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev'
    },
    pagination: {
        el: '.custom-pagination',
        type: 'custom',
        renderCustom: function(swiper, current, total) {
            return '<span class="first-number">' + ('0' + current).slice(-2) + '</span>' + '<span class="pgn-line">/</span>' + "<span class='second-number'>" + ('0' + total).slice(-2) + "</span>";
        }
    },
    on: {
        progress: function() {
            let interleaveOffset = 0.5;
            let swiper = this;
            for (let i = 0; i < swiper.slides.length; i++) {
                let slideProgress = swiper.slides[i].progress,
                    innerOffset = swiper.width * interleaveOffset,
                    innerTranslate = slideProgress * innerOffset;
                swiper.slides[i].querySelector('.img-slider').style.transform =
                    'translateX(' + innerTranslate + 'px)';
            }
        },
        setTransition: function(speed) {
            let swiper = this;
            for (let i = 0; i < swiper.slides.length; i++) {
                swiper.slides[i].style.transition = speed + 'ms';
                swiper.slides[i].querySelector('.img-slider').style.transition =
                    speed + 'ms';
            }
        },
        resize: function() {
            this.update();
        }
    }
};

// init slider
var parallaxSlider = new Swiper('.parallax-slider', parallaxSliderOptions);


// resize window
$(window).on('resize', function() {
    if ($('.swiper-container').hasClass('parallax-slider') == true) {
        parallaxSlider.update();
    }
});


var controller = new ScrollMagic.Controller();
var horizontalController = new ScrollMagic.Controller({ vertical: false });


/*- ANIMATION ABOUT SECTION -*/
var animationBg = anime({
    targets: ".img-anim-el",
    translateY: [0, -100],
    easing: 'linear',
    duration: 6000,

});
var imgAnimEl = new ScrollMagic.Scene({
    triggerElement: ".img-anim-el",
    offset: 200,
    duration: "100%",
    triggerHook: 1
}).setAnime(animationBg).addTo(controller);

var textAbout = anime({
    targets: ".about-text",
    translateY: [10, -100],
    easing: 'linear',
    duration: 6000,
});

var aboutText = new ScrollMagic.Scene({
    triggerElement: ".about-text",
    duration: "100%",
    triggerHook: 1
}).setAnime(textAbout).addTo(controller);


function removeAnimationText() {
    if ($(window).width() < 768) {
        aboutText.enabled(false);
        imgAnimEl.enabled(false);
        $('.about-text').css('transform', 'translateY(0)');
    } else {
        aboutText.enabled(true);
        imgAnimEl.enabled(true);
        setTimeout(function() {
            $('.img-anim-el').css('transform', 'translateY(0)');
        }, 1000);

    }
}

removeAnimationText();

$(window).resize(function() {
    removeAnimationText();
});

/*- ANIMATION PORTFOLIO IMAGE -*/
/*2-columns*/
$('.masonry-item-2').each(function() {
    var triggerEl = $(this).find(".img"),
        animImg = this.querySelector('.anim-el-works');

    var animationBg = anime({
        targets: animImg,
        translateY: [-150, 0],
        easing: 'linear',

    });

    new ScrollMagic.Scene({
        triggerElement: this,
        duration: "190%",
        triggerHook: 1
    }).setAnime(animationBg).addTo(controller);

});
/*3-columns*/
$('.masonry-item-3').each(function() {
    var triggerEl = $(this).find(".img"),
        animImg = this.querySelector('.anim-el-works');

    var animationBg = anime({
        targets: animImg,
        translateY: [-100, 0],
        easing: 'linear',

    });

    new ScrollMagic.Scene({
        triggerElement: this,
        duration: "150%",
        triggerHook: 1
    }).setAnime(animationBg).addTo(controller);

});

/*- ANIMATION HORIZONTAL PORTFOLIO IMAGE -*/
$('.horizontal-el').each(function() {
    var horizontalEl = this.querySelector('.htl-works-img'),
        numberImgEl = this.querySelector('.info-number');

    var animationHorBg = anime({
        targets: horizontalEl,
        translateX: [0, 0],
        easing: 'linear',
    });

    var animationNumberImgEl = anime({
        targets: numberImgEl,
        translateX: [100, 0],
        easing: 'linear',
    });

    new ScrollMagic.Scene({
        triggerElement: this,
        duration: "150%",
        triggerHook: 1,
    }).setAnime(animationHorBg).addTo(horizontalController);

    new ScrollMagic.Scene({
        triggerElement: this,
        duration: "100%",
        triggerHook: 1,
    }).setAnime(animationNumberImgEl).addTo(horizontalController);

});

/*- ANIMATION HEADER TEXT PAGE -*/
var widthHeaderText = -($('.header-text-bg-animation').width());
var haderAnimationBg = anime({
    targets: '.header-text-bg-animation',
    translateX: [500, widthHeaderText],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.header-text-bg',
    duration: "100%",
    triggerHook: 0.7,
}).setAnime(haderAnimationBg).addTo(controller);


/*- ANIMATION HEADER TEXT PAGE2 -*/
var widthHeaderText2 = -($('.header-text-bg-animation2').width());
var haderAnimationBg2 = anime({
    targets: '.header-text-bg-animation2',
    translateX: [1000, widthHeaderText2],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.header-text-bg2',
    duration: "100%",
    triggerHook: 0.7,
}).setAnime(haderAnimationBg2).addTo(controller);



/*- ANIMATION HEADER TEXT PAGE3 -*/
var widthHeaderText3 = -($('.header-text-bg-animation3').width());
var haderAnimationBg3 = anime({
    targets: '.header-text-bg-animation3',
    translateX: [1000, widthHeaderText3],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.header-text-bg3',
    duration: "100%",
    triggerHook: 0.5,
}).setAnime(haderAnimationBg3).addTo(controller);


/*- ANIMATION HEADER TEXT PAGE4 -*/
var widthHeaderText4 = -($('.header-text-bg-animation4').width());
var haderAnimationBg4 = anime({
    targets: '.header-text-bg-animation4',
    translateX: [1000, widthHeaderText4],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.header-text-bg4',
    duration: "100%",
    triggerHook: 0.5,
}).setAnime(haderAnimationBg4).addTo(controller);


/*- ANIMATION HEADER TEXT PAGE5 -*/
var widthHeaderText5 = -($('.header-text-bg-animation5').width());
var haderAnimationBg5 = anime({
    targets: '.header-text-bg-animation5',
    translateX: [1000, widthHeaderText5],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.header-text-bg5',
    duration: "100%",
    triggerHook: 0.5,
}).setAnime(haderAnimationBg5).addTo(controller);



/*- ANIMATION FUN FACTS -*/
function funFacts() {
    $('.anime-number').each(function() {
        var numberFact = $(this).attr('data-number');
        anime({
            targets: this,
            innerHTML: [0, numberFact],
            duration: 3000,
            easing: 'easeOutCubic',
            round: 1,
        });
    });
        $('.anime-number2').each(function() {
        var numberFact = $(this).attr('data-number');
        anime({
            targets: this,
            innerHTML: [0, numberFact],
            duration: 2000,
            easing: 'easeOutCubic',
            round: 1,
        });
    });
}

function funFacts2() {
    $('.anime-number').each(function() {
        var numberFact = $(this).attr('data-number');
        anime({
            targets: this,
            innerHTML: [0, numberFact],
            duration: 3000,
            easing: 'easeOutCubic',
            round: 1,
        });
    });
        $('.anime-number2').each(function() {
        var numberFact = $(this).attr('data-number');
        anime({
            targets: this,
            innerHTML: [0, numberFact],
            duration: 2000,
            easing: 'easeOutCubic',
            round: 1,
        });
    });
}

if ($('div').hasClass('fun-facts') === true) {
    new ScrollMagic.Scene({
        triggerElement: ".fun-facts",
        duration: "0",
        triggerHook: 1,
    }).addTo(controller).on("start", function(e) {
        funFacts();
    });;
}
/*- BACKGROUND ANIMATION FUN FACTS SECTION -*/
var widthFunFactsText = -($(window).width());
var windowHeight = $(window).height();
var factsAnimationBg = anime({
    targets: '.facts-trigger',
    translateX: [0, widthFunFactsText],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.fun-facts-bg',
    duration: windowHeight,
    triggerHook: .5,
}).setAnime(factsAnimationBg).addTo(controller);

if ($('div').hasClass('fun-facts2') === true) {
    new ScrollMagic.Scene({
        triggerElement: ".fun-facts2",
        duration: "0",
        triggerHook: 1,
    }).addTo(controller).on("start", function(e) {
        funFacts();
    });;
}
/*- BACKGROUND ANIMATION FUN FACTS SECTION -*/
var widthFunFactsText = -($(window).width());
var windowHeight = $(window).height();
var factsAnimationBg = anime({
    targets: '.facts-trigger',
    translateX: [0, widthFunFactsText],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.fun-facts-bg',
    duration: windowHeight,
    triggerHook: .5,
}).setAnime(factsAnimationBg).addTo(controller);

/*- SCROLLBAR -*/

// if ($('#main-scrollbar').length) {
//     var Scrollbar = window.Scrollbar;
//     var $elem = document.querySelector('#main-scrollbar');

//     Scrollbar.init($elem, {
//         damping: 0.05,
//     });
// }

if ($('#horizontal-scrollbar').length) {
    /*horizontal scroll*/
    var HorizontalScrollbar = window.Scrollbar;
    var htl_elem = document.querySelector('#horizontal-scrollbar');
    HorizontalScrollbar.use(HorizontalScrollPlugin, OverscrollPlugin /* you forgot this */ );


    HorizontalScrollbar.init(htl_elem, {
        damping: 0.05,
        plugins: {
            overscroll: {
                effect: 'bounce',
            },
        }
    });
}



/*- ANIMATIN PICTURE FRAME -*/
var durationAnime = $('.trigger-frame').height();

var photoFrame_1 = anime({
    targets: '.p-frame-1',
    translateY: [-20, 20],
    easing: 'linear',
    duration: 1000,

});
var photoFrame_2 = anime({
    targets: '.p-frame-2',
    translateY: [-40, 40],
    easing: 'linear',
    duration: 1000,

});
var photoFrame_3 = anime({
    targets: '.p-frame-3',
    translateY: [-60, 60],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.trigger-frame',
    duration: durationAnime,
    triggerHook: 0,
}).setAnime(photoFrame_1).addTo(controller);

new ScrollMagic.Scene({
    triggerElement: '.trigger-frame',
    duration: durationAnime,
    triggerHook: 0,
}).setAnime(photoFrame_2).addTo(controller);

new ScrollMagic.Scene({
    triggerElement: '.trigger-frame',
    duration: durationAnime,
    triggerHook: 0,
}).setAnime(photoFrame_3).addTo(controller);

/*- ANIMATIN PICTURE FRAME -*/
// var durationAnime = $('.trigger-frame').height();

// var photoFrame_1 = anime({
//     targets: '.p-frame-1',
//     translateY: [-20, 20],
//     easing: 'linear',
//     duration: 1000,

// });
// var photoFrame_2 = anime({
//     targets: '.p-frame-2',
//     translateY: [-40, 40],
//     easing: 'linear',
//     duration: 1000,

// });
// var photoFrame_3 = anime({
//     targets: '.p-frame-3',
//     translateY: [-60, 60],
//     easing: 'linear',
//     duration: 1000,

// });

// new ScrollMagic.Scene({
//     triggerElement: '.trigger-frame',
//     duration: durationAnime,
//     triggerHook: 0,
// }).setAnime(photoFrame_1).addTo(controller);

// new ScrollMagic.Scene({
//     triggerElement: '.trigger-frame',
//     duration: durationAnime,
//     triggerHook: 0,
// }).setAnime(photoFrame_2).addTo(controller);

// new ScrollMagic.Scene({
//     triggerElement: '.trigger-frame',
//     duration: durationAnime,
//     triggerHook: 0,
// }).setAnime(photoFrame_3).addTo(controller);



/*- ANIMATIN TAGLINE (HORIZONTAL PAGE) -*/
var durationAnimeTagline = $(window).width();

var htl_tagline_1 = anime({
    targets: '.htl-tagline-1',
    translateX: [200, 100],
    easing: 'linear',
    duration: 1000,

});
var htl_tagline_2 = anime({
    targets: '.htl-tagline-2',
    translateX: [400, 0],
    easing: 'linear',
    duration: 1000,

});
var htl_tagline_3 = anime({
    targets: '.htl-tagline-3',
    translateX: [600, 0],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.htl-section-tag',
    duration: durationAnimeTagline,
    triggerHook: 1,
}).setAnime(htl_tagline_1).addTo(horizontalController);

new ScrollMagic.Scene({
    triggerElement: '.htl-section-tag',
    duration: durationAnimeTagline,
    triggerHook: 1,
}).setAnime(htl_tagline_2).addTo(horizontalController);

new ScrollMagic.Scene({
    triggerElement: '.htl-section-tag',
    duration: durationAnimeTagline,
    triggerHook: 1,
}).setAnime(htl_tagline_3).addTo(horizontalController);

new ScrollMagic.Scene({
    triggerElement: '.htl-section2-tag',
    duration: durationAnimeTagline,
    triggerHook: 1,
}).setAnime(htl_tagline_1).addTo(horizontalController);

new ScrollMagic.Scene({
    triggerElement: '.htl-section2-tag',
    duration: durationAnimeTagline,
    triggerHook: 1,
}).setAnime(htl_tagline_2).addTo(horizontalController);

new ScrollMagic.Scene({
    triggerElement: '.htl-section2-tag',
    duration: durationAnimeTagline,
    triggerHook: 1,
}).setAnime(htl_tagline_3).addTo(horizontalController);

/*- ANIMATION HEADER TEXT PAGE -*/
var htlwidthHeaderText = $(window).width();
var htlAnimationBg = anime({
    targets: '.htl-text-bg-animation',
    translateX: [0, htlwidthHeaderText],
    easing: 'linear',
    duration: 1000,

});

new ScrollMagic.Scene({
    triggerElement: '.htl-text-bg-animation',
    duration: "100%",
    triggerHook: 0,
}).setAnime(htlAnimationBg).addTo(horizontalController);

/*-  SKILLBAR  -*/
function skillBar() {
    $('.circle').circleProgress({
        lineCap: 'butt',
        size: 140,
        thickness: 4,
        startAngle: -Math.PI / 5 * 10,
        emptyFill: "transparent",
        fill: {
            color: "#ee3636"
        },
        animation: {
            duration: 2200,
        }
    });
}

function numberSkill() {
    $('.circle').each(function() {
        var skillEl = this.lastChild;
        var numberSkill = ($(this).attr('data-value').slice(-2, 4)) + ' %';

        anime({
            targets: skillEl,
            innerHTML: [0, numberSkill],
            round: 1,
            duration: 2000,
            easing: 'easeOutCubic'
        });

    });
}

if ($('section').hasClass('skill') == true) {
        skillBar();
    new ScrollMagic.Scene({
        triggerElement: '.skill-bar-section',
        duration: "0",
        triggerHook: 1,
    }).addTo(controller).on("start", function(e) {
        skillBar();
        numberSkill();
    });

}

/*- HEADER PARALLAX BACKGROUND -*/
var homeParallaxImg = document.querySelector('.home-parallax-img');
var heightBgParallax = $(window).height();
var homeParallaxBg = anime({
    targets: homeParallaxImg,
    translateY: [0, heightBgParallax],
    easing: 'linear',

});

new ScrollMagic.Scene({
    triggerElement: '.home-parallax',
    duration: "300%",
    triggerHook: 0
}).setAnime(homeParallaxBg).addTo(controller);


/*SECTION PARALLAX BACKGROUND*/
var sectionParallaxImg = document.querySelector('.section-plx-bg');
var secPrxHeight = -($(window).height());
var sectionParallaxBg = anime({
    targets: sectionParallaxImg,
    translateY: [0, secPrxHeight],
    easing: 'linear',

});
new ScrollMagic.Scene({
    triggerElement: '.section-parallax-bg',
    duration: "400%",
    triggerHook: 1,
}).setAnime(sectionParallaxBg).addTo(controller);

/*- HEADER PARALLAX VARIANT-2-*/
/* item-2*/
var homeParallaxImgV2 = document.querySelector('.it-2');
var heightBgParallaxV2 = -($(window).height());
var homeParallaxBgV2 = anime({
    targets: homeParallaxImgV2,
    translateY: [0, heightBgParallaxV2],
    easing: 'linear',

});

new ScrollMagic.Scene({
    triggerElement: '.home-parallax-v2',
    duration: "600%",
    triggerHook: 0
}).setAnime(homeParallaxBgV2).addTo(controller);

/*item-3*/
var homeParallaxImgV3 = document.querySelector('.it-3');
var heightBgParallaxV3 = -($(window).height());
var homeParallaxBgV3 = anime({
    targets: homeParallaxImgV3,
    translateY: [0, heightBgParallaxV3],
    easing: 'linear',
});

new ScrollMagic.Scene({
    triggerElement: '.home-parallax-v2',
    duration: "200%",
    triggerHook: 0,
}).setAnime(homeParallaxBgV3).addTo(controller);


/*- HEADER SPLIT BACKGROUND -*/
var homeParallaxImg = document.querySelector('.home-split-img');
var heightBgParallax = $(window).height();
var homeParallaxBg = anime({
    targets: homeParallaxImg,
    translateY: [0, heightBgParallax],
    easing: 'linear',

});

new ScrollMagic.Scene({
    triggerElement: '.home-split',
    duration: "300%",
    triggerHook: 0
}).setAnime(homeParallaxBg).addTo(controller);

/*split pattern*/
var homeParallaxImg = document.querySelector('.home-split-content');
var heightBgPattern = $(window).height();
var homePatternxBg = anime({
    targets: homeParallaxImg,
    translateY: [0, heightBgPattern],
    easing: 'linear',

});

new ScrollMagic.Scene({
    triggerElement: '.home-split',
    duration: "500%",
    triggerHook: 0
}).setAnime(homePatternxBg).addTo(controller);

//--- YouTube Video ---
if ($("header").hasClass("ytp-video-bg") == true) {
    $("#video").YTPlayer({
        containment: 'header',
        playOnlyIfVisible: true,
        optimizeDisplay: true,
        fitToBackground: true,
        autoPlay: true,
        mute: true,
        startAt: 0,
        opacity: 1,
        showControls: false,
        realfullscreen: true,
        anchor: 'center,center',
    });
}

/*- CAROUSEL SLIDER -*/
var carouselOptions = {
    speed: 1000,
    loop: true,
    centeredSlides: false,
    slidesPerView: 3,
    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev'
    },
    pagination: {
        el: '.custom-pagination',
        type: 'custom',
        renderCustom: function(swiper, current, total) {
            return '<span class="first-number">' + ('0' + current).slice(-2) + '</span>' + '<span class="pgn-line">/</span>' + "<span class='second-number'>" + ('0' + total).slice(-2) + "</span>";
        }
    },
    breakpoints: {
        575.9: {
            slidesPerView: 1,
        },
        767.9: {
            slidesPerView: 2,
        }
    }
};

var carouselSlider = new Swiper('.carousel-slider', carouselOptions);

/*works link page*/
function showImage() {
    /* CONFIG */
    var xOffset = 200;
    var yOffset = 80;


    $("a.img-link-hover").hover(function(e) {

            var $this = $(this);

            $this.data('initialText', $this.text());
            $("body").append("<div id='show-image'><img src='" + this.rel + "' alt='rens preview image' />" + "</div>");
            $("#show-image").css("top", (e.pageY - xOffset) + "px").css("left", (e.pageX + yOffset) + "px").fadeIn("fast");
        },

        function() {
            var $this = $(this);
            $this.text($this.data('initialText'));
            $("#show-image").remove();
        });

    $("a.img-link-hover").mousemove(function(e) {
        $("#show-image").css("top", (e.pageY - xOffset) + "px").css("left", (e.pageX + yOffset) + "px");

    });
};

showImage();

/*- ANIMATION PORTFOLIO TOOLTIP BG -*/
var tooltipBg = document.querySelector('.portfolio-bg');
var animTooltipBg = anime({
    targets: tooltipBg,
    translateY: [0, -300],
    easing: 'linear',

});

new ScrollMagic.Scene({
    triggerElement: '.mouseOver_text',
    duration: "100%",
    triggerHook: 0.5
}).setAnime(animTooltipBg).addTo(controller);


/*- PARALLAX PROJECT PORTFOLIO -*/
var controllerParallaxBg = new ScrollMagic.Controller({ globalSceneOptions: { triggerHook: "onEnter", duration: "170%" } });

// build scenes
$('.wrap-panel').each(function() {
    var p_Works_Item = this.querySelector('.p-works-item');

    var parallaxWorks = anime({
        targets: p_Works_Item,
        translateY: '-30%',
        easing: 'linear',
    });

    new ScrollMagic.Scene({
        triggerElement: this,
    }).setAnime(parallaxWorks).addTo(controllerParallaxBg);

});


var controllerParallaxText = new ScrollMagic.Controller({ globalSceneOptions: { triggerHook: "onEnter", duration: "200%" } });

// build scenes
$('.p-works-item').each(function() {
    var pInfoWorks = this.querySelector('.p-info-works');

    var parallaxWorksText = anime({
        targets: pInfoWorks,
        translateY: [0, -300],
        easing: 'linear',
    });

    new ScrollMagic.Scene({
        triggerElement: this,
    }).setAnime(parallaxWorksText).addTo(controllerParallaxText);

});

/*- MAGNIFIC POPUP -*/
var imgLinkProject = $('.image-link-project');
if (imgLinkProject.length) {
    imgLinkProject.magnificPopup({
        type: 'image',
        mainClass: 'mfp-with-zoom',
        zoom: {
            enabled: true,
            duration: 500,
            easing: 'ease-in-out',
            opener: function(openerElement) {
                return openerElement.is('img') ? openerElement : openerElement.find('img');
            }
        }

    });
}
});